Attribute VB_Name = "createPolygon"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


'Visual Basic example  to create a polygon
'for a given number of sides and of a specified length on the active document

Dim app As ProDESKTOP          'Define variable used to hold the ProDESKTOP object
Dim part As PartDocument          'Define variable used to hold the PartDocument object

Dim numberOfSides As Integer                'Define variable used to hold the Number of sides of the polygon
Dim lengthOfSide As Double                  'Define variable used to hold the length of side of the polygon

Public Sub PolygonExample()

Call SetDataForPolygon
Call CreatePolygon(numberOfSides, lengthOfSide)

End Sub

Private Sub SetDataForPolygon()

'Set the User input for the number of sides and the length of the side.

Dim msgSide As String
Dim msgLength As String
msgSide = "Please Enter the number of sides of the polygon"
msgLength = "Please Enter the length of the side in meters"

numberOfSides = InputBox(msgSide, "Number of sides")
lengthOfSide = InputBox(msgLength, "Length of side")

End Sub

Private Sub CreatePolygon(numberOfSides As Integer, lengthOfSide As Double)

' Subroutine to create a polygon given the length and number of sides of
' of the polygon.

' Create the polygon on the Active sketch.
' Origin for the polygon is (0,0)

' Draws the first line by using the length value and assuming angle to be zero.
' Subsequent lines are drawn using cosine and sine of the exterior angle for the
' polygon.

Const pause As Boolean = False

'Connect to the ProDESKTOP Application object.
Set app = CreateObject("ProDESKTOP.Application")
    
If app Is Nothing Then        'Exit if no ProDESKTOP Application Object is created.
    MsgBox ("Could not create the ProDESKTOP Application Object")
    Exit Sub
End If

app.SetVisible (True)                'Make the ProDESKTOP Application Visible.

'Exit if no Part document is active
On Error GoTo NoDocErr
Set part = app.GetActiveDoc()        'Get the active document
On Error GoTo 0

'Take the helm
Dim api As helm
Set api = app.TakeHelm

'Create a SetClass
Dim setCls As ObjectSetClass
Set setCls = app.GetClass("ObjectSet")

'Create an Object Set
Dim objSet1 As ObjectSet
Set objSet1 = setCls.CreateAObjectSet

'Initialize the starting vectors
Let startx = 0#
Let starty = 0#
Let startz = 0#

'Create a VectorClass
Dim vecCls As VectorClass
Set vecCls = app.GetClass("Vector")

'Create the first vector
Dim firstVector  As ZVector
Set firstVector = vecCls.CreateVector(startx, starty, startz)

'Set the initial value for the Angle
Let pAngle = 0

'Set the initial values of x1,y1,z1
Let x1 = startx
Let y1 = starty
Let z1 = startz

For i = 1 To (numberOfSides - 1)

    'Create a vector using the x1,y1,z1 values
    Dim vector1  As ZVector
    Set vector1 = vecCls.CreateVector(x1, y1, z1)
    
    'Set the x2 coordinate  using the Cosine of the Angle and the Length of the side
    'Set the y2 coordinate  using the Sine of the Angle and the Length of the side
    
    X2 = x1 + lengthOfSide * Cos(pAngle)
    Y2 = y1 + lengthOfSide * Sin(pAngle)
    z2 = 0#
    
    'Create a vector using the x2,y2,z2 values
    Dim vector2  As ZVector
    Set vector2 = vecCls.CreateVector(X2, Y2, z2)
    
    'Use the Function CreateLine(startPt As ZVector, endPt As ZVector)
    'to create a line between the two given vectors
    
    Dim line As aLine
    Set line = CreateLine(vector1, vector2)
    
    'Add the line to the object set
    objSet1.AddMember line
    
    'Set the angle using the following formula
    pAngle = pAngle + 2 * 3.1415 / numberOfSides
    
    'Set the x1,y1,z1 values for the next iteration
    
    Let x1 = X2
    Let y1 = Y2
    Let z1 = z2

Next i                          'End Loop

'Create a Line using the CreateLine function between the last vector
'and the first vector in order to close the polygon

Dim lastLine As aLine
Set lastLine = CreateLine(vector2, firstVector)

'Add the last line to the object set
objSet1.AddMember lastLine

'Get the Active Workplane
Dim wp As aWorkplane
Set wp = part.GetActiveWorkplane

'Use the AutoConstrain API to constrain the line set.
wp.AutoConstrain objSet1

api.CommitCalls "Create Polygon", pause
Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub
        
End Sub

Private Function CreateLine(startPt As ZVector, endPt As ZVector)

'Get the Active Skecth and its parent workplane
Dim Sketch As aSketch
Set Sketch = part.GetActiveSketch
Dim plane As aWorkplane
Set plane = Sketch.GetParent("Workplane")

Dim startPoint As ZVector
Dim endPoint As ZVector

Dim localStart As ZVector
Dim localEnd As ZVector

'Get the local start and end vectors for the active workplane
Set localStart = plane.Get3DVector(startPt)
Set localEnd = plane.Get3DVector(endPt)

'Create a BasicStraightClass
Dim basicStrCls As BasicStraightClass
Set basicStrCls = app.GetClass("BasicStraight")

'Create a zCurve
Dim curve1 As zCurve
Set curve1 = basicStrCls.CreateBasicStraightTwoPoints(localStart, localEnd)

'Create a line by passing the zCurve
Dim line1 As aLine
Set line1 = Sketch.CreateLine(curve1)

Set CreateLine = line1

End Function



